﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;

public partial class PolyTraumaPatients : BasePage
{
    TBI_POLYTRAUMA polyTraumaPatient;
    PolyTraumaPatientManager polyTraumaPatientManager = new PolyTraumaPatientManager();

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string MenuItemName()
    {
        return "TBI POLY TRAUMA PATIENTS";
    }

    public override string AppObjectCode()
    {
        return "TBI POLY TRAUMA PATIENTS";
    }
  
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
            int? entryID = Convert.ToInt32(Request.QueryString["id"]);
            HiddenFieldEntryID.Value = entryID.GetValueOrDefault().ToString();

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (entryID == null || entryID == 0)
            {
                //set entryID to zero so that a default linq entity will be instantiated
                entryID = 0;

                //if a patient id is not requested, display patient search and hide all others panels
                PanelNoInsertAllowed.Visible = false;
                PanelSelectPatient.Visible = true;
                //Enable search controls for non-Admin users
                EnableAllControls(this.Controls);
            }
            else
            {
                //if patient id is requested hide patient search, show patient panel
                PanelSelectPatient.Visible = false;

                //Modify breadcrumb to display adding new
                LabelBreadCrumb.Text = LabelBreadCrumb.Text + " > Patient "; //ID : " + entryID;
            }
                       
        }

        if (IsPostBack)
        {
            LoadObjectFromControls();
        }

    }


    #region Postback Events


    #endregion


    #region Object/Form Mapping

    private void LoadObjectFromControls()
    {
    
    }

    #endregion


    protected void ButtonSearchPatient_Click(object sender, EventArgs e)
    {
        GridViewPatients.Visible = true;
        GridViewPatients.DataBind();
    }
  
}
